#include "mainwindow.h"
#include "ui_mainwindow.h"
#include <QFileDialog>

MainWindow *g_pMainwindow;

QRETURN on_process_signal_removed( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, PVOID pUserData )
{
    qDebug("signal removed \n");

    g_pMainwindow->m_str_info.sprintf("INFO : No signal detected");

    return QCAP_RT_OK;
}

QRETURN on_process_no_signal_detected( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, PVOID pUserData )
{
    ULONG i = (uintptr_t)pUserData;

    qDebug("no signal Detected \n");

    g_pMainwindow->m_str_info.sprintf("INFO : No signal detected");

    return QCAP_RT_OK;
}

QRETURN on_process_format_changed( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, ULONG nVideoWidth, ULONG nVideoHeight, BOOL bVideoIsInterleaved, double dVideoFrameRate, ULONG nAudioChannels, ULONG nAudioBitsPerSample,  ULONG nAudioSampleFrequency, PVOID pUserData )
{
    ULONG i = (uintptr_t)pUserData;

    qDebug("format changed Detected \n");

    CHAR strVideoInput[ 64 ] = { 0 };

    CHAR strAudioInput[ 64 ] = { 0 };

    CHAR strFrameType[ 64 ] = { 0 };

    int nVH = 0;

    g_pMainwindow->m_nVideoWidth[i] = nVideoWidth;

    g_pMainwindow->m_nVideoHeight[i] = nVideoHeight;

    g_pMainwindow->m_dVideoFrameRate[i] = dVideoFrameRate;

    g_pMainwindow->m_nAudioChannels[i] = nAudioChannels;

    g_pMainwindow->m_nAudioBitsPerSample[i] = nAudioBitsPerSample;

    g_pMainwindow->m_nAudioSampleFrequency[i] = nAudioSampleFrequency;

    if ( nVideoInput == 0 ) { sprintf( strVideoInput, "COMPOSITE" ); }

    if ( nVideoInput == 1 ) { sprintf( strVideoInput, "SVIDEO" ); }

    if ( nVideoInput == 2 ) { sprintf( strVideoInput, "HDMI" );}

    if ( nVideoInput == 3 ) { sprintf( strVideoInput, "DVI_D" );}

    if ( nVideoInput == 4 ) { sprintf( strVideoInput, "COMPONENTS (YCBCR)" );}

    if ( nVideoInput == 5 ) { sprintf( strVideoInput, "DVI_A (RGB / VGA)" );}

    if ( nVideoInput == 6 ) { sprintf( strVideoInput, "SDI" );}

    if ( nVideoInput == 7 ) { sprintf( strVideoInput, "AUTO" );}

    if ( nAudioInput == 0 ) { sprintf( strAudioInput, "EMBEDDED_AUDIO" );}

    if ( nAudioInput == 1 ) { sprintf( strAudioInput, "LINE_IN" );}

    if ( nAudioInput == 2 ) { sprintf( strAudioInput, "SOUNDCARD_MICROPHONE" );}

    if ( nAudioInput == 3 ) { sprintf( strAudioInput, "SOUNDCARD_LINE_IN" );}

    if ( bVideoIsInterleaved == TRUE ) { nVH = nVideoHeight / 2; } else { nVH = nVideoHeight; }

    if ( bVideoIsInterleaved == TRUE ) { sprintf( strFrameType, " I " ); } else { sprintf( strFrameType, " P " ); }

    g_pMainwindow->m_str_info.sprintf("INFO : %d x %d%s @%2.3f FPS , %d CH x %d BITS x %d HZ ,  VIDEO INPUT : %s ,  AUDIO INPUT : %s"

                                        ,nVideoWidth, nVH, strFrameType, dVideoFrameRate, nAudioChannels, nAudioBitsPerSample

                                        ,nAudioSampleFrequency, strVideoInput, strAudioInput);

    return QCAP_RT_OK;
}

QRETURN on_process_video_preview( PVOID pDevice, double dSampleTime, BYTE* pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData)
{
    ULONG i = (uintptr_t)pUserData;

    ULONG colorkey, val_blue, val_green, val_red, val_th, val_alpha;

    if ( i == 1 && g_pMainwindow->m_bEnableColorKey == true) {

        val_blue = (g_pMainwindow->ui->label_Blue->text().toInt() * 255 ) << 16;

        val_green = (g_pMainwindow->ui->label_Green->text().toInt() * 255 ) << 8;

        val_red = (g_pMainwindow->ui->label_Red->text().toInt() * 255 );

        val_th = g_pMainwindow->ui->label_Threshold->text().toInt();

        val_alpha = g_pMainwindow->ui->label_Alpha->text().toInt();

        colorkey = val_blue + val_green + val_red;

        QCAP_SET_OSD_BUFFER_EX(g_pMainwindow->m_pDevice[0], 0,
                               200, 0, 1280, 1080, QCAP_COLORSPACE_TYPE_YV12, pFrameBuffer, g_pMainwindow->m_nVideoWidth[1], g_pMainwindow->m_nVideoHeight[1], g_pMainwindow->m_nVideoWidth[1]
                               , 200, 0, 1200, 1080, 0 , 0, val_alpha, colorkey, val_th);

    }

    return QCAP_RT_OK;
}

QRETURN on_process_audio_preview( PVOID pDevice, double dSampleTime, BYTE* pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData)
{
    ULONG i = (uintptr_t)pUserData;

    return QCAP_RT_OK;
}


MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);

    g_pMainwindow = this;


    ui->Slider_Alpha->setRange(0, 255);

    ui->Slider_Red->setRange(0, 1);

    ui->Slider_Green->setRange(0, 1);

    ui->Slider_Blue->setRange(0, 1);

    ui->Slider_Threshold->setRange(0, 255);

    ui->Slider_Alpha->setValue(255);

    ui->Slider_Green->setValue(1);

    ui->Slider_Threshold->setValue(22);

    m_bEnableColorKey = 0;

    for ( ULONG i = 0; i < 2; i ++ ) {

        m_pDevice[ i ] = NULL;

        m_nVideoWidth[ i ] = 0;

        m_nVideoHeight[ i ] = 0;

        m_dVideoFrameRate[ i ] = 0.0;

        m_bVideoIsInterleaved[ i ] = 0;

        m_nAudioChannels[ i ] = 0;

        m_nAudioBitsPerSample[ i ] = 0;

        m_nAudioSampleFrequency[ i ] = 0;
    }

    QCAP_CREATE( "QP0203 PCI", 0, (HWND)ui->frame_1->winId(), &m_pDevice[0] );

    QCAP_CREATE( "QP0203 PCI", 1, (HWND)ui->frame_2->winId(), &m_pDevice[1] );


    for ( ULONG i = 0; i < 2; i ++ ) {

        QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK( m_pDevice[i], on_process_no_signal_detected, (PVOID)i );

        QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK( m_pDevice[i], on_process_signal_removed, (PVOID)i );

        QCAP_REGISTER_FORMAT_CHANGED_CALLBACK( m_pDevice[i], on_process_format_changed, (PVOID)i );

        QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK( m_pDevice[i], on_process_video_preview, (PVOID)i );

        QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK( m_pDevice[i], on_process_audio_preview, (PVOID)i );

        QCAP_SET_AUDIO_SOUND_RENDERER(m_pDevice[i], 0);

        QCAP_RUN( m_pDevice[i] );
    }
}

MainWindow::~MainWindow()
{
    for ( ULONG i = 0; i < 2; i ++ ) {

        if ( m_pDevice[i] ) {

            QCAP_STOP( m_pDevice[i] );

            QCAP_DESTROY( m_pDevice[i] );
        }
    }

    delete ui;
}

void MainWindow::on_Slider_Alpha_valueChanged(int value)
{
    QString str_tmp;

    str_tmp.sprintf("%d", value);

    ui->label_Alpha->setText( str_tmp );
}

void MainWindow::on_Slider_Red_valueChanged(int value)
{
    QString str_tmp;

    str_tmp.sprintf("%d", value);

    ui->label_Red->setText( str_tmp );
}

void MainWindow::on_Slider_Green_valueChanged(int value)
{
    QString str_tmp;

    str_tmp.sprintf("%d", value);

    ui->label_Green->setText( str_tmp );
}

void MainWindow::on_Slider_Blue_valueChanged(int value)
{
    QString str_tmp;

    str_tmp.sprintf("%d", value);

    ui->label_Blue->setText( str_tmp );
}

void MainWindow::on_Slider_Threshold_valueChanged(int value)
{
    QString str_tmp;

    str_tmp.sprintf("%d", value);

    ui->label_Threshold->setText( str_tmp );
}

void MainWindow::on_pushButton_clicked()
{
    m_bEnableColorKey = true;
}
